﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm



    ' 用于保存进程以进行更快的检索的集合
    Private processes As System.Collections.Generic.SortedList(Of String, Process)
    ' 用于显示模块详细信息的子窗体引用
    Private modulesForm As Modules

    ' 用于在列表视图中显示的字符串常量
    Private Const NAProcess As String = "N/A"
    Private Const TotalProcess As String = "_Total (0x0)"
    Private Const IdleProcess As String = "Idle"
    Private Const SystemProcess As String = "System"

    ' 由 AddNameValuePair 使用来减少键入工作
    Private mits As ListView.ListViewItemCollection


    Private Sub frmMain_Load(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load, MyBase.Load
        ' 加载进程列表
        EnumProcesses()
    End Sub

    Private Sub lvProcesses_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles lvProcesses.SelectedIndexChanged
        Try
            Dim lv As ListView = lvProcesses

            If lv.SelectedItems.Count = 1 Then
                ' 从第一个子项列获取进程 ID
                Dim processId As String = lv.SelectedItems(0).SubItems(1).Text

                ' 检查我们是否已获取虚设的“total”进程
                If processId = NAProcess Then
                    Me.lvProcessDetail.Items.Clear()
                    Me.lvThreads.Items.Clear()
                    Exit Sub
                End If

                Dim p As Process

                p = CType(processes.Item(processId), Process)
                ' 获取最新数据
                p.Refresh()

                ' 获取进程详细信息
                EnumProcess(p)
                ' 获取线程详细信息
                EnumThreads(p)
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)

        End Try
    End Sub

    Private Sub mnuModules_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles ModulesToolStripMenuItem.Click, ModuleContextMenuItem.Click
        ' 加载子窗体以显示模块信息
        Try
            Dim lv As ListView = Me.lvProcesses

            If lv.SelectedItems.Count = 1 Then

                Dim strProcessId As String = lv.SelectedItems(0).SubItems(1).Text
                ' 检查我们是否已获取虚设的“total”进程
                If strProcessId = NAProcess Then
                    Exit Sub
                End If

                Dim p As Process

                p = CType(processes.Item(strProcessId), Process)

                ' 不要枚举空闲进程。
                ' 您将接收到访问拒绝错误。
                If p.ProcessName = IdleProcess Then
                    Exit Sub
                End If
                ' 不显示任何内容
                If p.ProcessName = SystemProcess Then
                    Exit Sub
                End If
                p.Refresh()

                ' 最后，检查我们是否甚至可以 
                ' 获取模块计数。
                ' 如果不能，则没有必要继续。
                Try
                    Dim i As Integer = p.Modules.Count
                Catch exp As System.ComponentModel.Win32Exception
                    MessageBox.Show("Sorry, you are not authorized to read this information.", Me.Text, MessageBoxButtons.OK, MessageBoxIcon.Exclamation)
                    Exit Sub
                End Try
                ' 如果窗体不可用，则加载它
                If modulesForm Is Nothing Then
                    modulesForm = New Modules
                End If

                ' 传递所选进程
                modulesForm.ParentProcess = p
                ' 获取模块数据
                modulesForm.RefreshModules()
                ' 显示窗体
                modulesForm.ShowDialog(Me)
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)
        End Try
    End Sub

    Private Sub mnuRefresh_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles RefreshToolStripMenuItem.Click, RefreshContextMenuItem.Click
        ' 刷新进程列表
        Me.StatusStrip1.Text = "Refreshing list, please wait"
        Me.StatusStrip1.Refresh()
        EnumProcesses()
        Me.StatusStrip1.Text = "Ready"
    End Sub

    Private Sub AddNameValuePair(ByVal Item As String, ByVal SubItem As String)
        ' 将名称/值对添加到列表视图控件的帮助器过程
        With mits.Add(Item)
            .SubItems.Add(SubItem)
        End With
    End Sub

    Private Sub EnumThreads(ByVal p As Process)
        ' 获取进程的线程信息。
        ' 此信息是关于物理 Win32 线程
        ' 而不是 System.Threading.Thread 线程的。
        Try
            Me.lvThreads.Items.Clear()

            Dim strProcessId As String = ""

            If strProcessId = NAProcess Then
                Me.lvThreads.Items.Add(NAProcess)
            Else
                Dim t As ProcessThread

                ' 各线程时间的 Timespan
                Dim tpt As TimeSpan
                Dim tppt As TimeSpan
                Dim tupt As TimeSpan

                For Each t In p.Threads
                    ' 获取线程时间并存储
                    tppt = t.PrivilegedProcessorTime
                    tupt = t.UserProcessorTime
                    tpt = t.TotalProcessorTime

                    ' 线程的用户处理器时间百分比
                    Dim strPUPT As String = CDbl(tupt.Ticks / tpt.Ticks).ToString("#0%")
                    If tupt.Ticks = 0 Then
                        strPUPT = "0%"
                    End If

                    ' 线程的特权处理器时间百分比
                    Dim strPPPT As String = CDbl(tppt.Ticks / tpt.Ticks).ToString("#0%")
                    If tppt.Ticks = 0 Then
                        strPPPT = "0%"
                    End If

                    Dim strTPT As String
                    With tpt
                        strTPT = (.Days.ToString("00") & "." & .Hours.ToString("00") & ":" & .Minutes.ToString("00") & ":" & .Seconds.ToString("00"))
                    End With

                    With Me.lvThreads.Items.Add(t.Id.ToString())
                        .SubItems.Add(t.BasePriority.ToString())
                        .SubItems.Add(t.CurrentPriority.ToString())
                        Try
                            .SubItems.Add(t.PriorityBoostEnabled.ToString())
                        Catch exp As System.ComponentModel.Win32Exception
                            .SubItems.Add("N/A")
                        End Try
                        Try
                            .SubItems.Add(t.PriorityLevel.ToString())
                        Catch exp As System.ComponentModel.Win32Exception
                            .SubItems.Add("N/A")
                        End Try

                        .SubItems.Add(strPPPT)
                        .SubItems.Add(Hex(t.StartAddress.ToInt32()).ToLower())
                        .SubItems.Add(t.StartTime.ToShortDateString() & " " & t.StartTime.ToShortTimeString())
                        .SubItems.Add(strTPT)
                        .SubItems.Add(strPUPT)
                    End With
                Next
            End If
        Catch exp As Exception
            MessageBox.Show(exp.Message, exp.Source, MessageBoxButtons.OK, MessageBoxIcon.Error)

        End Try

    End Sub

    Private Sub EnumProcess(ByVal p As Process)
        ' 获取进程信息
        Dim lv As ListView = Me.lvProcessDetail
        lv.Items.Clear()

        If p.ProcessName = IdleProcess Then
            Exit Sub
        End If

        mits = lv.Items

        Try
            Dim valuePairs()() As Object = { _
                New Object() {"Start Time", p.StartTime.ToLongDateString() & " " & p.StartTime.ToLongTimeString(), ""}, _
                New Object() {"Responding", p.Responding, ""}, _
                New Object() {"Handle", p.Handle, ""}, _
                New Object() {"Handle Count", p.HandleCount, "N0"}, _
                New Object() {"Main Window Handle", p.MainWindowHandle, ""}, _
                New Object() {"Main Window Title", p.MainWindowTitle, ""}, _
                New Object() {"Module Count", p.Modules.Count, "N0"}, _
                New Object() {"Base Priority", p.BasePriority, ""}, _
                New Object() {"Working Set", p.WorkingSet64, "N0"}, _
                New Object() {"Peak Working Set", p.PeakWorkingSet64, "N0"}, _
                New Object() {"Private Memory Size", p.PrivateMemorySize64, "N0"}, _
                New Object() {"Nonpaged System Memory Size", p.NonpagedSystemMemorySize64, "N0"}, _
                New Object() {"Paged Memory Size", p.PagedMemorySize64, "N0"}, _
                New Object() {"Peak Paged Memory Size", p.PeakPagedMemorySize64, "N0"}, _
                New Object() {"Virtual Memory Size", p.VirtualMemorySize64, "N0"}, _
                New Object() {"Peak Virtual Memory Size", p.PeakVirtualMemorySize64, "N0"}, _
                New Object() {"Priority Boost Enabled", p.PriorityBoostEnabled, ""}, _
                New Object() {"Priority Class", p.PriorityClass, ""}, _
                New Object() {"Processor Affinity", p.ProcessorAffinity.ToInt32, ""}, _
                New Object() {"Thread Count", p.Threads.Count, ""}, _
                New Object() {"Min Working Set", p.MinWorkingSet.ToInt32, "N0"}, _
                New Object() {"Max Working Set", p.MaxWorkingSet.ToInt32, "N0"}, _
                New Object() {"Main Module", IIf(p.MainModule Is Nothing, "", p.MainModule.ModuleName), ""}}

            Me.AddPairs(valuePairs)
        Catch ex As Exception
            MsgBox("One or more of the process properities is not available: " & vbCrLf & ex.Message, _
                MsgBoxStyle.Critical, ex.Source)
        End Try

    End Sub

    Private Sub AddPairs(ByVal pairs()() As Object)
        Const NA As String = "Not Available"

        Dim nPairs As Integer = pairs.GetLength(0)
        For index As Integer = 0 To nPairs - 1
            Dim pair() As Object = pairs(index)
            ' 第一项为标题
            Dim newItem As ListViewItem = mits.Add(pair(0).ToString)
            ' 第二项为值，第三项为格式字符串
            ' 如果存在格式字符串，则值为 Long 或 Integer 类型。
            If CType(pair(2), String) <> "" Then
                Try
                    Dim format As String = CStr(pair(2))
                    Dim value As Long = CType(pair(1), Long)
                    Dim contents As String = value.ToString(format)
                    newItem.SubItems.Add(contents)
                Catch ex As Exception
                    newItem.SubItems.Add(NA)
                End Try
            Else
                Try
                    newItem.SubItems.Add(pair(1).ToString)
                Catch ex As Exception
                    newItem.SubItems.Add(NA)
                End Try
            End If
        Next
    End Sub


    Private Sub EnumProcesses()
        ' 枚举所有进程
        Try
            Dim processList() As Process

            ' 各进程信息的 Timespan
            Dim total As TimeSpan
            Dim privileged As TimeSpan
            Dim user As TimeSpan

            ' 计算机的 Timespan
            Dim totalTotal As TimeSpan
            Dim privilegedTotal As TimeSpan
            Dim userTotal As TimeSpan

            processes = New System.Collections.Generic.SortedList(Of String, Process)

            Me.lvProcesses.Items.Clear()
            Me.lvProcessDetail.Items.Clear()
            Me.lvThreads.Items.Clear()

            processList = Process.GetProcesses()

            For Each p As Process In processList
                Try
                    processes.Add(p.Id.ToString, p)

                    ' 获取处理器时间并存储
                    privileged = p.PrivilegedProcessorTime
                    user = p.UserProcessorTime
                    total = p.TotalProcessorTime

                    ' 将当前进程的时间添加到总时间。
                    totalTotal = totalTotal.Add(total)
                    privilegedTotal = privilegedTotal.Add(privileged)
                    userTotal = userTotal.Add(user)

                    ' 用户处理器时间百分比
                    Dim userPercent As String = CDbl(user.Ticks / total.Ticks).ToString("#0%")
                    ' 特权处理器时间百分比
                    Dim privilegedPercent As String = CDbl(privileged.Ticks / total.Ticks).ToString("#0%")

                    Dim totalString As String = FormatTimeSpan(total)

                    Dim processItem As ListViewItem = _
                        Me.lvProcesses.Items.Add(p.ProcessName & " (0x" & Hex(p.Id).ToLower() & ")")
                    With processItem
                        .SubItems.Add(p.Id.ToString())
                        .SubItems.Add(totalString)
                        .SubItems.Add(privilegedPercent)
                        .SubItems.Add(userPercent)
                    End With
                Catch ex As Exception
                    ' 我们将忽略无法枚举（即无法访问）的所有进程
                End Try
            Next

            ' 总用户处理器时间百分比
            Dim stringUserPercent As String = CDbl(userTotal.Ticks / totalTotal.Ticks).ToString("#0%")
            ' 总特权处理器时间百分比
            Dim stringPrivilegedPercent As String = CDbl(privilegedTotal.Ticks / totalTotal.Ticks).ToString("#0%")

            Dim stringTotalTotal As String = FormatTimeSpan(totalTotal)

            ' 为所有进程添加项
            With Me.lvProcesses.Items.Add(TotalProcess)
                .SubItems.Add(NAProcess)
                .SubItems.Add(stringTotalTotal)
                .SubItems.Add(stringPrivilegedPercent)
                .SubItems.Add(stringUserPercent)
            End With
        Catch exp As Exception
            MsgBox(exp.Message, MsgBoxStyle.Critical, exp.Source)
        End Try
    End Sub


    Private Function FormatTimeSpan(ByVal interval As TimeSpan) As String
        Return _
            interval.Days.ToString("00") & "." & _
            interval.Hours.ToString("00") & ":" & _
            interval.Minutes.ToString("00") & ":" & _
            interval.Seconds.ToString("00")
    End Function

    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class